#!/bin/sh

# This is a script for collecting system information for the technical Merlin support
# Copyright (c) 2005-2014 ProjectWizards, Melle, Germany.
# Author: Frank Blome
#
# Version: 1.1
# ak: added parameters for directory and filename
#
# Version 1.2
# vs: added licensing info output

# Create Folder for the information
WORKFOLDER=$1
FOLDER=$2
BUNDLE_IDENTIFIER=$3
PROCESS_NAME=$4
PROCESS_NAME=$(printf %q "$PROCESS_NAME")
APP_INFO=$5

#echo $WORKFOLDER
#echo $FOLDER
#echo $BUNDLE_IDENTIFIER
#echo $PROCESS_NAME

if [ -n "$WORKFOLDER" ]; then
	:
else
	WORKFOLDER=~/Desktop
fi
if [ -n "$FOLDER" ]; then
	:
else
	DATE=`date "+%Y-%m-%d"`
	FOLDER=Profile-$DATE
fi
#echo $WORKFOLDER
#echo $FOLDER

cd "$WORKFOLDER"
mkdir "$FOLDER"

# Get Merlin Stuff
eval "cp ~/Library/Logs/DiagnosticReports/$PROCESS_NAME*.crash $FOLDER/"
eval "cp /Library/Logs/DiagnosticReports/$PROCESS_NAME*.crash $FOLDER/"
eval "cp ~/Library/Logs/DiagnosticReports/$PROCESS_NAME*.hang $FOLDER/"
eval "cp /Library/Logs/DiagnosticReports/$PROCESS_NAME*.hang $FOLDER/"
eval "cp ~/Library/Logs/DiagnosticReports/$PROCESS_NAME*.diag $FOLDER/"
eval "cp /Library/Logs/DiagnosticReports/$PROCESS_NAME*.diag $FOLDER/"

/usr/bin/defaults read $BUNDLE_IDENTIFIER > $FOLDER/$BUNDLE_IDENTIFIER.plist.txt

echo $APP_INFO > $FOLDER/App_Info.txt

# Get license info
eval "ls -la ~/Library/Application\ Support/$PROCESS_NAME/Licenses > $FOLDER/pre_sandbox_licenses.txt"
eval "ls -la ~/Library/Containers/$BUNDLE_IDENTIFIER/Data/Library/Application\ Support/$BUNDLE_IDENTIFIER/Licenses > $FOLDER/licenses.txt"

# Get System Profiler Report
/usr/sbin/system_profiler -xml -detailLevel basic > $FOLDER/system_profile.spx 2> /dev/null

# Get df
/bin/df > $FOLDER/df.txt

# Get mount
/sbin/mount > $FOLDER/mount.txt

# Get top
# /usr/bin/top > $FOLDER/top.txt

# Get network information

echo "#" > $FOLDER/network.txt
echo "# netstat -n -r" >> $FOLDER/network.txt
echo "#" >> $FOLDER/network.txt
/usr/sbin/netstat -n -r >> $FOLDER/network.txt

echo "#" >> $FOLDER/network.txt
echo "# lsof -n -P" >> $FOLDER/network.txt
echo "#" >> $FOLDER/network.txt
/usr/sbin/lsof -n -P >> $FOLDER/network.txt

echo "#" >> $FOLDER/network.txt
echo "# netstat -n -a -A -f inet" >> $FOLDER/network.txt
echo "#" >> $FOLDER/network.txt
/usr/sbin/netstat -n -a -A -f inet >> $FOLDER/network.txt

echo "#" >> $FOLDER/network.txt
echo "# netstat -i -n -d" >> $FOLDER/network.txt
echo "#" >> $FOLDER/network.txt
/usr/sbin/netstat -i -n -d >> $FOLDER/network.txt

# Get process information
/bin/ps axwww > $FOLDER/ps.txt

# Get logfiles
cp /var/log/system.log "$FOLDER/system.log.txt"

# doesn't work without password
# cp /Library/Logs/Console/console.log $FOLDER/console.log.txt

# zip the folder
tar cfz "$FOLDER.tgz" "$FOLDER"
rm -Rf "$FOLDER"

echo "SUPPORT PROFILE GENERATION FINISHED"
